/*!
 * Copyright 2012 E.J.I.E., S.A.
 *
 * Licencia con arreglo a la EUPL, Versión 1.1 exclusivamente (la «Licencia»);
 * Solo podrá usarse esta obra si se respeta la Licencia.
 * Puede obtenerse una copia de la Licencia en
 *
 *      http://ec.europa.eu/idabc/eupl.html
 *
 * Salvo cuando lo exija la legislación aplicable o se acuerde por escrito, 
 * el programa distribuido con arreglo a la Licencia se distribuye «TAL CUAL»,
 * SIN GARANT�AS NI CONDICIONES DE NINGÚN TIPO, ni expresas ni implícitas.
 * Véase la Licencia en el idioma concreto que rige los permisos y limitaciones
 * que establece la Licencia.
 */

jQuery(document).ready(function(){
	//logo
	$("#rup_dept_logo").attr("src", $.rup.APP_STATICS + "/images/dept_logo_" + $.rup.lang + ".gif");
		
	//rastro de migas
	var subLevelBandejas = [
	    { "i18nCaption": "bandeja_telematicos", "url": "/ab03bRERAWar/ab03b23v00/maint" }
	];
	var subLevelExpedientes = [
	    { "i18nCaption": "busqueda_expedientes", "url": "/ab03bRERAWar/ab03b24v00/maint" },
	    { "i18nCaption": "cierre_expedientes", "url": "/ab03bRERAWar/expedientesCierre/filtro" }
	];
	var subLevelMantenimientos = [
	    { "i18nCaption": "mantenimiento_cargos", "url": "/ab03bRERAWar/ab03b03t00/maint" },
	    { "i18nCaption": "mantenimiento_firmantes", "url": "/ab03bRERAWar/ab03b04t00/maint" },
	    { "i18nCaption": "mantenimiento_plantillas", "url": "/ab03bRERAWar/ab03b21t00/maint" },
	    { "i18nCaption": "mantenimiento_organismos", "url": "/ab03bRERAWar/ab03b49t00/maint" },
	    { "i18nCaption": "mantenimiento_tipos_documentos", "url": "/ab03bRERAWar/ab03b44t00/maint" }
	];
	var subLevelEstadisticas = [
	    { "i18nCaption": "estadisticas_1", "url": "/ab03bRERAWar/estadAltasBajas/maint" }
	];
	var subLevelEmpresas = [
	    { "i18nCaption": "empresas_registradas", "url": "/ab03bRERAWar/ab03b47v00/maint" }
	];

	$("#ab03bRERAWar_migas").rup_breadCrumb({
		breadCrumb: {
			"ab03b23v00": {
				"i18nCaption": "bandejas_entrada",
				"maint": { "i18nCaption": "bandeja_telematicos" },
				"subLevel": subLevelBandejas
			},
			"ab03b24v00": {
				"i18nCaption": "expedientes",
				"maint": { "i18nCaption": "busqueda_expedientes" },
				"subLevel": subLevelExpedientes
			},
			"tramitacion": {
				"i18nCaption": "expedientes",
				"maint": { "i18nCaption": "busqueda_expedientes" },
				"subLevel": subLevelExpedientes
			},
			"expedientesCierre": {
				"i18nCaption": "expedientes",
				"filtro": { "i18nCaption": "cierre_expedientes" },
				"subLevel": subLevelExpedientes
			},
			"ab03b03t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_cargos" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b04t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_firmantes" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b21t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_plantillas" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b49t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_organismos" },
				"subLevel": subLevelMantenimientos
			},
			"ab03b44t00": {
				"i18nCaption": "mantenimientos",
				"maint": { "i18nCaption": "mantenimiento_tipos_documentos" },
				"subLevel": subLevelMantenimientos
			},
			"estadAltasBajas": {
				"i18nCaption": "estadisticas",
				"maint": { "i18nCaption": "estadisticas_1" },
				"subLevel": subLevelEstadisticas
			},
			"ab03b47v00": {
				"i18nCaption": "empresas",
				"maint": { "i18nCaption": "empresas_registradas" },
				"subLevel": subLevelEmpresas
			}
		},
		initUrl: "start",
		i18nId: "ab03bRERAWar_migas",
		logOutUrl : $.rup.CTX_PATH + "logout"
	});
	
	//idioma
	$("#ab03bRERAWar_language").rup_language({languages: $.rup.AVAILABLE_LANGS_ARRAY, modo: "portal"});
	
	// linea en blanco de los combos
	$.rup.i18n.base.rup_combo.blankNotDefined = $.rup.i18n.app.mantenimientos.todas;//"--Todas--";
	
	//menu
	$("#ab03bRERAWar_menu").rup_menu({
		display: ($.rup.LAYOUT === "vertical" ? 'vertical' : 'horizontal')
	});
	if ($.rup.LAYOUT === "mixto") {
		$("#ab03bRERAWar_menu_mixto").rup_menu({
			display: 'vertical'
		});
	}
	
	//pie
	$(".footer [title]").rup_tooltip();
});